/******************************************************************************
 * (C) Copyright 2000 by Agilent Technologies GmbH. All rights reserved.      *
 ******************************************************************************/


/* ***********************************************************************
   *                                                                     *
   * regx11.h                                                            *
   * Christian Zurhorst, BID R&D, 24. Sep. 1997                          *
   *                                                                     *
   * defines for second command byte and 16-bit commands                 *
   *                                                                     *
   ***********************************************************************
*/

#include <xregxdir.h>

#define MERGE_SERVICES(cmd)        CMD_MERGE (CMDG_SERVICES, cmd)


/* making settings resident and recalling */

#define CMDM_ALL_PROP_STORE        0x05
#define CMD_ALL_PROP_STORE        MERGE_SERVICES (CMDM_ALL_PROP_STORE)
#define IN_ALL_PROP_STORE         0
#define OUT_ALL_PROP_STORE         0

#define CMDM_ALL_PROP_LOAD        0x06
#define CMD_ALL_PROP_LOAD        MERGE_SERVICES (CMDM_ALL_PROP_LOAD)
#define IN_ALL_PROP_LOAD         0
#define OUT_ALL_PROP_LOAD         0


/* power up properties */

#define CMDM_PU_PROP_SET        0x07
#define CMD_PU_PROP_SET            MERGE_SERVICES (CMDM_PU_PROP_SET)
#define IN_PU_PROP_SET             5
#define OUT_PU_PROP_SET             0

#define CMDM_PU_PROP_GET        0x08
#define CMD_PU_PROP_GET            MERGE_SERVICES (CMDM_PU_PROP_GET)
#define IN_PU_PROP_GET             1
#define OUT_PU_PROP_GET             4


/* block mode setup and cleanup */

/* Params; ULONG offset, ULONG num_bytes, USHORT resource, USHORT write_cmd */
#define CMDM_BLOCK_MODE_SET        0x10
#define CMD_BLOCK_MODE_SET        MERGE_SERVICES (CMDM_BLOCK_MODE_SET)
#define IN_BLOCK_MODE_SET        11
#define OUT_BLOCK_MODE_SET            0

#define CMDM_BLOCK_MODE_CLEANUP        0x11
#define CMD_BLOCK_MODE_CLEANUP        MERGE_SERVICES (CMDM_BLOCK_MODE_CLEANUP)
#define IN_BLOCK_MODE_CLEANUP         0
#define OUT_BLOCK_MODE_CLEANUP         0


/* reading the version information out of the hardware */
#define CMDM_VERSION_GET        0x20
#define CMD_VERSION_GET            MERGE_SERVICES (CMDM_VERSION_GET)
#define IN_VERSION_GET             1
#define OUT_VERSION_GET            BX_LENGTH_NEGOTIATE


/* retrieve a copy of the 32-bit system status register */
#define CMDM_SYS_STATUS_GET        0x21
#define CMD_SYS_STATUS_GET        MERGE_SERVICES (CMDM_SYS_STATUS_GET)
#define IN_SYS_STATUS_GET         0
#define OUT_SYS_STATUS_GET         4 /* 1 DWORD */

/* clear all applicable (allowed) bits in the system status register */
#define CMDM_SYS_STATUS_CLR        0x22
#define CMD_SYS_STATUS_CLR        MERGE_SERVICES (CMDM_SYS_STATUS_CLR)
#define IN_SYS_STATUS_CLR         4 /* 1 DWORD ... a mask */
#define OUT_SYS_STATUS_CLR         0


/* generate a PCI interrupt */
#define CMDM_INTR_GENERATE        0x23
#define CMD_INTR_GENERATE        MERGE_SERVICES (CMDM_INTR_GENERATE)
#define IN_INTR_GENERATE         1 /* byte mask */
#define OUT_INTR_GENERATE         0

/* write to the PME bit */
#define CMDM_PME_WRITE            0x24
#define CMD_PME_WRITE            MERGE_SERVICES(CMDM_PME_WRITE)
#define IN_PME_WRITE             1 /* PME Bit */
#define OUT_PME_WRITE             0

/* read the PME bit */
#define CMDM_PME_READ            0x25
#define CMD_PME_READ            MERGE_SERVICES(CMDM_PME_READ)
#define IN_PME_READ             0 
#define OUT_PME_READ             1

/* debug or release build? */
#define CMDM_CHECKBUILD_READ        0x2a
#define CMD_CHECKBUILD_READ        MERGE_SERVICES(CMDM_CHECKBUILD_READ)
#define IN_CHECKBUILD_READ         0
#define OUT_CHECKBUILD_READ         1

/* direct register read has been moved to pg.10\h / cmd 83\h */

/* direct register write */
#define CMDM_REGISTER_WRITE        0x31
#define CMD_REGISTER_WRITE        MERGE_SERVICES (CMDM_REGISTER_WRITE)
#define IN_REGISTER_WRITE         9
#define OUT_REGISTER_WRITE         0

#define CMDM_ROMRAM_READ        0x32
#define CMD_ROMRAM_READ            MERGE_SERVICES (CMDM_ROMRAM_READ)
#define IN_ROMRAM_READ             8
#define OUT_ROMRAM_READ            BX_LENGTH_NEGOTIATE

/* entries - 0x37 reserved for direct memory access */

#define CMDM_MEM_ALLOC                  0x38
#define CMD_MEM_ALLOC                   MERGE_SERVICES (CMDM_MEM_ALLOC)
#define IN_MEM_ALLOC                     4
#define OUT_MEM_ALLOC                    4

#define CMDM_MEM_FREE                   0x39
#define CMD_MEM_FREE                    MERGE_SERVICES (CMDM_MEM_FREE)
#define IN_MEM_FREE                      4
#define OUT_MEM_FREE                     0

/* entries - 0x3f reserved for memory manipulation */

/* commands to program and display number on the back leds */
#define CMDM_HEX_DISPLAY        0x40
#define CMD_HEX_DISPLAY                MERGE_SERVICES (CMDM_HEX_DISPLAY)
#define IN_HEX_DISPLAY             1
#define OUT_HEX_DISPLAY                 0

#define CMDM_HEX_SHOW                0x41
#define CMD_HEX_SHOW                MERGE_SERVICES (CMDM_HEX_SHOW)
#define IN_HEX_SHOW             1
#define OUT_HEX_SHOW                 0

#define CMDM_HWFLASH_PROG           0x42
#define CMD_HWFLASH_PROG            MERGE_SERVICES (CMDM_HWFLASH_PROG)
#define IN_HWFLASH_PROG             12
#define OUT_HWFLASH_PROG            0

/* board properties */
#define CMDM_BOARD_PROP_SET        0x50
#define CMD_BOARD_PROP_SET        MERGE_SERVICES (CMDM_BOARD_PROP_SET)
#define IN_BOARD_PROP_SET         5
#define OUT_BOARD_PROP_SET         0

#define CMDM_BOARD_PROP_GET        0x51
#define CMD_BOARD_PROP_GET        MERGE_SERVICES (CMDM_BOARD_PROP_GET)
#define IN_BOARD_PROP_GET         1
#define OUT_BOARD_PROP_GET         4

#define CMDM_BOARD_PROP_STORE        0x52
#define CMD_BOARD_PROP_STORE        MERGE_SERVICES (CMDM_BOARD_PROP_STORE)
#define IN_BOARD_PROP_STORE         5
#define OUT_BOARD_PROP_STORE         0

#define CMDM_BOARD_STOREDPROP_GET    0x53
#define CMD_BOARD_STOREDPROP_GET     MERGE_SERVICES (CMDM_BOARD_STOREDPROP_GET)
#define IN_BOARD_STOREDPROP_GET        1
#define OUT_BOARD_STOREDPROP_GET    4

/* System Information (read-only) */
#define CMDM_SYSTEM_INFO_GET        0x54
#define CMD_SYSTEM_INFO_GET        MERGE_SERVICES (CMDM_SYSTEM_INFO_GET)
#define IN_SYSTEM_INFO_GET         1
#define OUT_SYSTEM_INFO_GET         4

/* onboard clock */
#define CMDM_CLOCK_SET            0x60
#define CMD_CLOCK_SET            MERGE_SERVICES (CMDM_CLOCK_SET)
#define IN_CLOCK_SET             4
#define OUT_CLOCK_SET             0

#define CMDM_CLOCK_GET            0x61
#define CMD_CLOCK_GET            MERGE_SERVICES (CMDM_CLOCK_GET)
#define IN_CLOCK_GET             0
#define OUT_CLOCK_GET             4


/* self test functions */
#define CMDM_ICHIBAN_MEM_TEST        0xe0
#define CMD_ICHIBAN_MEM_TEST        MERGE_SERVICES (CMDM_ICHIBAN_MEM_TEST)
#define IN_ICHIBAN_MEM_TEST         1
#define OUT_ICHIBAN_MEM_TEST         0

/* self test functions */
#define CMDM_BOARD_HW_TEST        0xe1
#define CMD_BOARD_HW_TEST        MERGE_SERVICES (CMDM_BOARD_HW_TEST)
#define IN_BOARD_HW_TEST         1
#define OUT_BOARD_HW_TEST         0

#if 0
/* do a core switch .. */
#define CMDM_CORE_SWITCH        0xf0
#define CMD_CORE_SWITCH            MERGE_SERVICES (CMDM_CORE_SWITCH)
#define IN_CORE_SWITCH             0
#define OUT_CORE_SWITCH             0

/* reset functions */
#define CMDM_BOARD_RESET        0xf1
#define CMD_BOARD_RESET            MERGE_SERVICES (CMDM_BOARD_RESET)
#define IN_BOARD_RESET             0
#define OUT_BOARD_RESET             0
#endif

/* reset functions */
#define CMDM_SM_RESET            0xf2
#define CMD_SM_RESET            MERGE_SERVICES (CMDM_SM_RESET)
#define IN_SM_RESET             0
#define OUT_SM_RESET             0

#define CMDM_BOARD_RESTART        0xf3
#define CMD_BOARD_RESTART        MERGE_SERVICES (CMDM_BOARD_RESTART)
#define IN_BOARD_RESTART         0
#define OUT_BOARD_RESTART         0

#define CMDM_DBG_TERM_WRITE        0xfe
#define CMD_DBG_TERM_WRITE        MERGE_SERVICES (CMDM_DBG_TERM_WRITE)
#define IN_DBG_TERM_WRITE        BX_LENGTH_NEGOTIATE
#define OUT_DBG_TERM_WRITE         0

#define CMDM_KNIGHT_RIDER        0xff
#define CMD_KNIGHT_RIDER        MERGE_SERVICES (CMDM_KNIGHT_RIDER)
#define IN_KNIGHT_RIDER             4
#define OUT_KNIGHT_RIDER         0

